-- Statements für DBUpdates (nicht in StandardSQL, da in neuer Datenbank auch schon vor der ersten Syncro benötigt)
CREATE OR REPLACE FUNCTION TSystem.dbupdates_statements(
  OUT DBRID_DBUpdateBeforeAll  VARCHAR,
  OUT DBRID_DBUpdateBefore     VARCHAR,
  OUT DBRID_DBUpdateAfter      VARCHAR,
  OUT DBRID_AfterCheck_RE      VARCHAR,
  OUT DBRID_AfterRepair        VARCHAR,
  OUT DBRID_AfterCheck_Once_RE VARCHAR,
  OUT DBRID_AfterRepair_Once   VARCHAR,
  OUT DBRID_SqlNeedsDBRID_RE   VARCHAR,
  OUT DBRID_Execute            VARCHAR,
  OUT DBRID_ExecuteQuick       VARCHAR,
  OUT DBRID_ViewsExistsCheck   VARCHAR,
  OUT DBUPDATE_SetDoneDate     VARCHAR
  ) RETURNS RECORD AS $$
  BEGIN
    -- Wenn diese Funktion fehlt oder nicht geladen werden konnte (z.B. fehlende Parameter), dann wird Ersatz verwendet.
    -- siehe UCimDatabase.DBRID_LoadStatements

    -- Für CI-Tests ist eine Kopie von DBRID_DBUpdateBeforeAll+DBRID_Execute in "PSQL\0300 Functions\ZZZZ SQLField Generator Execute.sql".
    -- DB-Erstellung im Prodat (UFormDBCreate) überspringt diese SQL-Datei und stattdessen führt DBRID_Execute im PRODAT aus. (siehe TDBCreateForm.CREATEIDFIELD).

    -- "DISABLE TRIGGER ALL, upd_sql, ENABLE TRIGGER ALL" immer in einer Transaktion. (Tabellen sind so lange gelockt und kein anderes Update trifft auf dieser disableten Trigger)
    -- Alle DBRID-Funktionen/Zeilen werden einzeln ausgeführt, aber innerhalb einer Transaktion. (falls Eins knallt raucht nicht alles ab)
    -- DBRID : Explizit oder nach "Alle DBUpdates"   = DBRID_Execute
    --         FailStart oder nach "Einzel-DBUpdate" = DBRID_ExecuteQuick
    --         nach "Einzel-DBUpdate ohne Trigger"   = DBRID_AfterRepair_Once ("ohne Trigger" = kein DropViews)

    -- Einzeln ohne Trigger :                           BEGIN, DBRID_DBUpdateBefore, upd_sql, DBRID_DBUpdateAfter, COMMIT/ROLLBACK, DBUPDATE_SetDoneDate, DBRID_AfterCheck_Once:DBRID_AfterRepair_Once
    -- Einzeln ohne Views   : DBRID_DBUpdateBeforeAll,  BEGIN, DBRID_DBUpdateBefore, upd_sql, DBRID_DBUpdateAfter, COMMIT/ROLLBACK, DBUPDATE_SetDoneDate,                                      DBRID_ExecuteQuick
    -- alle DBUpdates       : DBRID_DBUpdateBeforeAll ( BEGIN, DBRID_DBUpdateBefore, upd_sql, DBRID_DBUpdateAfter, COMMIT/ROLLBACK, DBUPDATE_SetDoneDate, DBRID_AfterCheck:DBRID_AfterRepair ) DBRID_Execute
    --                        =DROP VIEW                       =DISABLE TRIGGER      =UPDATE  =ENABLE TRIGGER                       =SET upd_donedat      =REPAIR VIEW                         =CREATE VIEW + DBRID
    -- siehe : TFormEditSQL.miOpenClick, TFormSql.miOpenExternClick und TFormDBUpdates.btExecuteDBUpdatesClick/miExecuteSingleClick/ExecuteUpdate

    -- Enable All Trigger   : Settings__GetBool('triggersdisabled') : SELECT TSystem.triggers__all__enable();
    -- Disable All Trigger  :                                         SELECT TSystem.triggers__all__disable();
    -- Create All Views     : DBRID_ViewsExistsCheck                : SELECT TSystem.views__all__create();
    -- Drop All Views       :                                         SELECT TSystem.views__all__drop();
    -- DBRID (Create All)   : Settings__GetBool('DoCREATEIDFIELD')  : DBRID_DBUpdateBeforeAll + DBRID_Execute

    -- Zeilenumbruch = #10
    -- alle SQL mit abschließendem Zeilenumbruch
    -- Init- und Disable-Statements mit mindestens 4 Leerzeichen vor Kommentaren (alles außer DBRID_Execute/DBRID_ExecuteQuick)
    -- Kommentare auf gleicher Höhe (sieht im SQL-Log und bei "SQL extern Ausführen" besser aus)

    -- TFormDBUpdates.DisableTriggersAndDropViews und TFormEditSQL.miOpenClick


    -- vor allen DBUpdates / vor Einzel-DBUpdate wenn "ohne Views"
    DBRID_DBUpdateBeforeAll  := E'SELECT TSystem.tablefieldinfo__recreate();             -- UPDATE TableFieldInfo \n'
                             || E'SELECT TSystem.views__all__drop();                     -- DROP VIEW \n';

    -- vor/nach jedem einzelnen DBUpdate (bei Alles und Einzeln ausführen)
    DBRID_DBUpdateBefore     := E'SELECT TSystem.triggers__all__disable();               -- DISABLE TRIGGER \n';
    DBRID_DBUpdateAfter      := E'SELECT TSystem.triggers__all__enable();                -- ENABLE TRIGGER \n';

    -- Reparaturmaßnahmen nach DBUpdate (bei Alles ausführen - VIEWSs waren gelöscht )
    DBRID_AfterCheck_RE      := E'CREATE VIEW|views__all__create';
    DBRID_AfterRepair        := E'SELECT TSystem.views__all__drop();                     -- DROP VIEW, da im SQL ein CREATE VIEW gefunden \n';

    -- Reparaturmaßnahmen nach DBUpdate (bei Einzeln ausführen ohne VIEWs - VIEWs )
    DBRID_AfterCheck_Once_RE := E'DROP VIEW|views__all__drop';
    DBRID_AfterRepair_Once   := E'SELECT TSystem.views__all__drop();                     -- DROP VIEW \n'
                             || E'SELECT TSystem.views__all__create();                   -- CREATE VIEW, da im SQL ein DROP VIEW gefunden \n';

    -- für "Einzeln ausführen ohne VIEWs", als Hinweis, dass etwas vielleicht doch nötig wäre (views__all__create, tables__dbrid_index__create_missing oder tables__generate_missing_fields)
    DBRID_SqlNeedsDBRID_RE   := E'CREATE TABLE|CREATE VIEW|DROP TABLE|DROP VIEW|ALTER TABLE';

    -- bei DBRID und nach allen DBUpdates
    DBRID_Execute            := DBRID_DBUpdateBeforeAll
                             || E'SELECT TSystem.tables__generate_missing_fields();      -- CREATE COLUMN: dbrid, insert_date, modified_date, ... \n'
                             || E'SELECT TSystem.tables__dbrid_index__create_missing();  -- CREATE INDEX: dbrid \n'
                             || E'SELECT TSystem.tables__dbrid_index__rename();          -- RENAME INDEX: dbrid \n'
                             || E'SELECT TSystem.tables__enforce__fieldtypes();          -- SET TYPE: dbrid, insert_by, ... \n'
                             || E'SELECT TSystem.tables__cleanup_unused_fields();        -- DROP COLUMN: wvod, doku, abkstru \n'
                             || E'SELECT TSystem.views__all__create();                   -- CREATE VIEW \n'
                             || E'SELECT TSystem.triggers__all__enable();                -- ENABLE TRIGGER \n'
                             || E'SELECT TSystem.tablefieldinfo__recreate();             -- UPDATE TableFieldInfo: neue Infos für''s laufende Programm \n'
                             || E'SELECT TSystem.Settings__Set(''DoCREATEIDFIELD'', False); \n';

    -- nach Einzel-DBUpdates (mit VIEWs) und in TFormDBUpdates.FormCreate (schnelleres Laden nach einem Initialisierungs-Fehler des PRODAT)
    DBRID_ExecuteQuick       := E'SELECT TSystem.tables__generate_missing_fields();      -- CREATE COLUMN: dbrid, insert_date, modified_date, ... \n'
                             || E'SELECT TSystem.tables__dbrid_index__create_missing();  -- CREATE INDEX: dbrid \n'
                             || E'SELECT TSystem.views__all__create();                   -- CREATE VIEW \n'
                             || E'SELECT TSystem.triggers__all__enable();                -- ENABLE TRIGGER \n'
                             || E'SELECT TSystem.tablefieldinfo__recreate();             -- UPDATE TableFieldInfo: neue Infos für''s laufende Programm \n'
                             || E'SELECT TSystem.Settings__Set(''DoCREATEIDFIELD'', False); \n';

    DBRID_ViewsExistsCheck   := E'SELECT to_regclass(''public.adressen_view'') IS NOT NULL \n';

    DBUPDATE_SetDoneDate     := E'SELECT disablemodified(); \n'
                             || E'UPDATE dbupdates SET upd_donedat = NULL  WHERE dbrid = :id   AND :mode = ''clear''      AND  upd_donedat IS NOT NULL; \n'
                             || E'UPDATE dbupdates SET upd_donedat = Now() WHERE dbrid = :id   AND :mode ~ ''done|close'' AND (upd_donedat IS NULL OR :mode = ''done''); \n'
                             || E'UPDATE dbupdates SET upd_donedat = Now() WHERE NOT upd_sperr AND :mode = ''doneall''    AND  upd_donedat IS NULL; \n'
                             || E'SELECT enablemodified(); \n';
  END $$ LANGUAGE plpgsql;
--

-- #10668 - Updatesichere kundenspezifische Views
CREATE OR REPLACE FUNCTION TSystem.views__customer__drop() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu löschen. Sie werden noch vor den PORDAT-Views gelöscht.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier gelöschten Views müssen in FUNCTION TSystem.views__customer__create erzeugt werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

    -- DROP VIEW IF EXISTS..

    -- ################################################################################
    -- # x2e                                                                          #
    -- ################################################################################

    -- 17441 Schnittstelle Altium Designer Umsetzung
    --PERFORM z_50_customer.entity_types__drop();
    --DROP SCHEMA IF EXISTS altium CASCADE; -- Es sind nur Views im Schema altium enthalten.
    -- 17441 Ende

    --
    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.views__all__drop() RETURNS void AS $$
  BEGIN
    -- im Programm wird an einigen Stellen geprüft, ob die VIEWs gelöscht sind
    -- das PrüfSQL dafür befindet sich in DBRID_ViewsExistsCheck (TSystem.dbupdates_statements)

    -- eine "alte" Version des DROP-VIEWs befindet sich in TFormDBUpdates.ExecuteDBRIDCode(...; DoDisableAll), für Upgrade einer uralten Datenbank,
    -- da diese Funktionen erst über DB-Updates eingespielt werden. (falls vergessen wurde zuerst die DB und dann das Programm zu tauschen)

    --IF (SELECT lower('namespace') = lower(nspname) FROM pg_namespace ORDER BY 1 DESC LIMIT 1) THEN
    --IF (SELECT lower('namespace.functionname') = lower(nspname||'.'||proname) FROM pg_proc JOIN pg_namespace ON pronamespace = pg_namespace.oid ORDER BY 1 DESC LIMIT 1) THEN
    --BEGIN  ...  EXCEPTION WHEN OTHERS THEN ; END;

    -- mobile views
    IF (
        SELECT  lower( nspname || '.' || proname ) = lower( 'x_20_mobile.views__drop' )
        FROM pg_proc
        JOIN pg_namespace ON pronamespace = pg_namespace.oid
        ORDER BY 1 DESC
        LIMIT 1
    ) THEN
        PERFORM x_20_mobile.views__drop();
    END IF;

    PERFORM TCache.CachedViews_Clear();

    -- Immer als Erstes die kundenspezifischen Views löschen
      -- #10668
    BEGIN
      PERFORM TSystem.views__customer__drop();    -- Drop-Funktion für kundenspezifische Views
    EXCEPTION WHEN OTHERS THEN
      RAISE NOTICE 'Error TSystem.views__customer__drop';
    END;

    -- Warenwirtschaftsviews
    PERFORM TSystem.views__TWawi__drop();

    -- Reporting-Views
    PERFORM TSystem.views__treporting__drop();

    PERFORM TSystem.views__artikel__drop();
    PERFORM TSystem.views__beleg__drop();
    PERFORM TSystem.views__Adressen__drop();

    -- Sonderfall: Varial-Export
    BEGIN
     PERFORM TSystem.views__x_900_export__Varial__drop();
    EXCEPTION WHEN OTHERS THEN
    END;

    -- single drop views
    DROP VIEW IF EXISTS textx;
    DROP VIEW IF EXISTS art_lang;
    DROP VIEW IF EXISTS bdepabsum;
    DROP VIEW IF EXISTS urlaubsum;
    DROP VIEW IF EXISTS cycles_info;
    DROP VIEW IF EXISTS tartikel.art_multilang CASCADE;
    DROP VIEW IF EXISTS anfrageservice;
    DROP VIEW IF EXISTS qabService;
    DROP VIEW IF EXISTS opl_standard;
    DROP VIEW IF EXISTS tpersonal.llv__stundauszahl__karenzantrag;


    -- Sonderfall: ASK TeilePrüfprotokoll / Messmittelplan
    BEGIN
      DROP VIEW IF EXISTS oplpm;
    EXCEPTION WHEN OTHERS THEN -- Abwärtskompatibilität: wenn kein VIEW (noch Tabelle), dann ignorieren.
    END;


    DROP VIEW IF EXISTS systemsqlstatement_current;


    -- Sonderfall: TDMS
    IF (SELECT lower('TDMS') = lower(nspname) FROM pg_namespace ORDER BY 1 DESC LIMIT 1) THEN
      DROP VIEW IF EXISTS TDMS.External_DMS__get_Documents;
    END IF;


    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.views__all__create() RETURNS VOID AS $$
  BEGIN
    --IF (SELECT lower('namespace') = lower(nspname) FROM pg_namespace ORDER BY 1 DESC LIMIT 1) THEN
    --IF (SELECT lower('namespace.functionname') = lower(nspname||'.'||proname) FROM pg_proc JOIN pg_namespace ON pronamespace = pg_namespace.oid ORDER BY 1 DESC LIMIT 1) THEN
    --BEGIN  ...  EXCEPTION WHEN OTHERS THEN ; END;

    --sonstige Views, das BDE Zeug muß noch gemacht werden

    PERFORM TSystem.views__Adressen__recreate(); -- inkl. TSystem.views__project__create()
    PERFORM TSystem.views__beleg__recreate();
    --Reporting-Views
    PERFORM TSystem.views__treporting__recreate();
    --Warenwirtschaftsviews
    PERFORM TSystem.views__twawi__recreate();
    -- Cycles_Info
    PERFORM TSystem.view__cycles_info__recreate();
    --
    CREATE OR REPLACE VIEW anfrageservice AS
        SELECT * FROM kundanfrage WHERE kanf_isService;
    --
    CREATE OR REPLACE VIEW qabService AS
        SELECT * FROM qab WHERE q_isService;
    --
    CREATE OR REPLACE VIEW oplpm AS
        SELECT * FROM oplpm_data WHERE pm_a2_id IS NULL;
    --
    CREATE OR REPLACE VIEW opl_standard AS
        SELECT * FROM opl WHERE op_standard;

    --
    IF (SELECT lower('TDMS.view__External_DMS__get_Documents__recreate') = lower(nspname || '.' || proname)
          FROM pg_proc JOIN pg_namespace ON pronamespace = pg_namespace.oid
         ORDER BY 1 DESC
         LIMIT 1
        )
    THEN
        PERFORM TDMS.view__External_DMS__get_Documents__recreate();
    END IF;

    -- beachte auch Y 0.Base.Views+Rules.sql
    CREATE OR REPLACE VIEW textx AS
        SELECT prodat_languages.lang_text(t_nr) AS t_feld,
               *
          FROM text0;

    --Artikel
    PERFORM TSystem.views__artikel__recreate();
      -- Views zur Berechnung der auf Monat summierten Abwesenheit
        -- Beachte: initiale Erzeugung auch in Y 0.Base.Views+Rules.sql
      CREATE OR REPLACE VIEW bdepabsum AS
        SELECT mpl_formonth, mpl_date, mpl_minr,
               sum(bdab_stu) AS bdab_stu, ab_id, CAST(ab_txt AS TEXT),
               bdab_buch
          FROM mitpln
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE ( bdab_stu IS NOT NULL OR (bdepab.bdab_anf = bdepab.bdab_end AND mpl_feiertag IS NOT null) ) -- https://redmine.prodat-sql.de/issues/19299
         --AND mpl_feiertag IS NULL => nicht, da es Abwesenheiten an Feiertagen gibt (zB Feiertag im Kanton A, aber Schule in Kanton B). Wenn der Tag ausdrücklich benannt wurde, dann nehmen wir den auch rein!
         GROUP BY ab_id, ab_txt, mpl_minr, mpl_date, bdab_buch, mpl_formonth
      UNION
        SELECT mpl_formonth, mpl_date, mpl_minr,
               CASE WHEN ab_id = 100 THEN CAST(tpl_abw AS NUMERIC) / 2 ELSE tpl_abw END AS bdab_stu, ab_id, CAST(ab_txt AS TEXT),
               bdab_buch
          FROM mitpln JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN tplan ON (mpl_tpl_name = tplan.tpl_name)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NULL
           AND mpl_feiertag IS NULL; -- da Urlaube teilweise ÜBER Feiertage hinweg gehen, muss das ausgeschlossen werden!

      CREATE OR REPLACE VIEW urlaubsum AS
        SELECT mpl_formonth, mpl_date, mpl_minr, sum(bdab_stu) AS bdab_stu, ab_id, ab_txt
          FROM mitpln
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NOT NULL
           AND NOT bdab_buch
           AND ab_id = 1
           AND mpl_feiertag IS NULL
         GROUP BY ab_id, ab_txt, mpl_minr, mpl_date, mpl_formonth
      UNION
        SELECT mpl_formonth, mpl_date, mpl_minr, tpl_abw AS bdab_stu, ab_id, ab_txt
          FROM mitpln
          JOIN bdepab ON (mitpln.mpl_minr = bdepab.bdab_minr) AND (mitpln.mpl_date BETWEEN bdepab.bdab_anf AND bdepab.bdab_end)
          JOIN tplan ON (mpl_tpl_name = tplan.tpl_name)
          LEFT JOIN bdeabgruende ON (bdab_aus_id = bdeabgruende.ab_id)
         WHERE bdab_stu IS NULL
           AND NOT bdab_buch
           AND ab_id = 1
           AND mpl_feiertag IS NULL;
    --

    -- Karenz-Überzeit-Beantragung
    PERFORM TSystem.view__tpersonal__llv__stundauszahl__karenzantrag__recreate();

    --
    CREATE OR REPLACE VIEW systemsqlstatement_current AS
      SELECT *
      FROM systemsqlstatement
      WHERE NOT sql_deleted
        AND NOT EXISTS(SELECT true  -- existiert eine neuere Version?
          FROM systemsqlstatement AS x
          WHERE x.sql_name = systemsqlstatement.sql_name
            AND NOT x.sql_deleted
            AND COALESCE(x.sql_minver, '') <= TSystem.Settings__Get('ProdatVersion')
            AND COALESCE(x.sql_minver, '') > COALESCE(systemsqlstatement.sql_minver, ''))
        AND COALESCE(sql_minver, '') <= TSystem.Settings__Get('ProdatVersion');

  -- Views, welche nicht zwingend sind. TODO: trotzdem Fehlermeldung raus.
    -- Varial-Export
    BEGIN
      PERFORM TSystem.views__x_900_export__varial__recreate();
    EXCEPTION WHEN OTHERS THEN
    END;
    --- #10668
    BEGIN -- Immer als Letztes die kundenspezifischen Views erzeugen
      PERFORM TSystem.views__customer__create();    -- Create-Funktion für kundenspezifische Views
    EXCEPTION WHEN OTHERS THEN
       PERFORM PRODAT_ERROR( 'Error TSystem.views__customer__create' );
    END;

    -- freda views
    IF (
        SELECT  lower( nspname || '.' || proname ) = lower( 'x_20_mobile.views__recreate' )
        FROM pg_proc
        JOIN pg_namespace ON pronamespace = pg_namespace.oid
        ORDER BY 1 DESC
        LIMIT 1
    ) THEN
        PERFORM x_20_mobile.views__recreate();
    END IF;

    --- Grant's für Rolle erstellen
    PERFORM TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle('SYS.Prodat-User');

  END $$ LANGUAGE plpgsql;
--

--

-- #10668 - Updatesichere kundenspezifische Views
CREATE OR REPLACE FUNCTION TSystem.views__customer__create() RETURNS VOID AS $$
    --
    -- BITTE UNBEDINGT DIE HINWEISE BEACHTEN ---------------------------------------------------------------------------------------
    --
    -- Diese Funktion darf niemals in ein DB-Update aufgenommen werden! Die Funktion immer vor Ort beim Kunden ändern!
    --
    -- Dies ist eine Funktion, um kundenspezifische Views zu erzeugen. Sie werden nach den PRODAT-Views erstellt.
    -- Diese Funktion darf niemals in einem DB-Update überschrieben werden. Damit würden Einstellungen beim Kunden verloren gehen!
    -- Die hier erzeugten Views müssen in FUNCTION TSystem.views__customer__drop wieder gelöscht werden.
    --
    -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/CustomView
    --
    --------------------------------------------------------------------------------------------------------------------------------
    --
  BEGIN

    -- CREATE VIEW..

    -- ################################################################################
    -- # x2e                                                                          #
    -- ################################################################################

    -- 17441 Schnittstelle Altium Designer
    --PERFORM z_50_customer.entity_types__recreate();
    --PERFORM z_50_customer.create_altium_views();
    -- 17441 Ende

    --
    RETURN;
  END $$ LANGUAGE plpgsql;
--

-- renames old _idindex to new table__dbrid index
CREATE OR REPLACE FUNCTION TSystem.tables__dbrid_index__rename() RETURNS setof text AS $$
  DECLARE
      _index_row record;
      _sql text;
  BEGIN
      FOR _index_row IN
        SELECT
            table_class.relname AS table_name,
            table_namespace.nspname AS schema_name,
            index_class.relname AS index_name,
            pg_attribute.attname AS column_name
        FROM pg_index

        -- indclass is type oidvector which is zero based!
        JOIN pg_opclass ON pg_index.indclass[0] = pg_opclass.oid

        -- attribute is type int2vector also zero based
        JOIN pg_attribute ON pg_index.indrelid = pg_attribute.attrelid AND pg_attribute.attnum = pg_index.indkey[0]
        JOIN pg_class index_class ON index_class.oid = pg_index.indexrelid
        JOIN pg_class table_class ON table_class.oid = pg_index.indrelid

        -- [for index] No schema name can be included here;
        -- the index is always created in the same schema as its parent table.
        JOIN pg_namespace table_namespace ON table_class.relnamespace = table_namespace.oid
        WHERE
              -- only single column indices
              pg_index.indnatts = 1

              -- only text ops index
          AND pg_opclass.opcname ~ 'text_ops'

              -- only for dbrid field
          AND pg_attribute.attname = 'dbrid'

              -- ignore correctly named indices
          AND index_class.relname <> table_class.relname ||  '__dbrid'

              -- ignore drop schema
          AND table_namespace.nspname not in ('z_99_drop')

              -- only for regular tables
          AND table_class.relkind = 'r'
      LOOP

          _sql := format(
              'ALTER INDEX IF EXISTS %I.%I RENAME TO %I__dbrid',
              _index_row.schema_name,
              _index_row.index_name,
              _index_row.table_name
          );

          EXECUTE _sql;
          return next _sql;

      END LOOP;


  END $$ LANGUAGE plpgsql;
--

-- creates missing __dbrid index
CREATE OR REPLACE FUNCTION TSystem.tables__dbrid_index__create_missing() RETURNS void AS $$
    DECLARE
      table_is_fdw bool;
      row          RECORD;
    BEGIN
        FOR row IN SELECT * FROM TSystem.tables__fieldInfo__fetch() WHERE schemaname NOT IN ('z_99_drop') AND has_dbrid AND NOT has_dbrid_index
        LOOP
            table_is_fdw := TSystem.tables__is_fdw(row.tablename, row.schemaname);
            IF NOT table_is_fdw THEN
              -- raise notice 'CREATE UNIQUE INDEX %__dbrid ON %.% (dbrid);', row.tablename,row.schemaname,row.tablename;
              EXECUTE FORMAT ('CREATE UNIQUE INDEX %I__dbrid ON %I.%I (dbrid);', row.tablename,row.schemaname,row.tablename);
            END IF;
        END LOOP;
    END $$ LANGUAGE plpgsql;
--

-- Holt Tabelleneigenschaften zur Vorbereitung von DBRID
CREATE OR REPLACE FUNCTION TSystem.tables__fieldInfo__fetch()
  RETURNS TABLE (
    tablename             VARCHAR(100),
    schemaname            VARCHAR(100),
    has_dbrid             BOOLEAN,
    has_dbrid_index       BOOLEAN,
    has_insert_date       BOOLEAN,
    has_insert_by         BOOLEAN,
    has_modified_by       BOOLEAN,
    has_modified_date     BOOLEAN,
    has_wvod              BOOLEAN,
    has_doku              BOOLEAN,
    has_abk               BOOLEAN,
    has_no_recno          BOOLEAN,
    has_modified_trigger  BOOLEAN,
    dbrid_not_varchar32   BOOLEAN,
    does_not_need_dbrid   BOOLEAN,
    does_not_need_dates   BOOLEAN,
    does_not_need_recno   BOOLEAN
  ) AS $$
      SELECT
        -- the cast is required since information_schema has only »sql_identifier« type
        _tables.table_name::varchar                                                                           AS tablename,
        _tables.table_schema::varchar                                                                         AS schemaname,
        BOOL_OR(COALESCE(_columns.column_name, '') = 'dbrid')                                                 AS has_dbrid,
        BOOL_OR(_indexes.indexname IS NOT NULL)                                                               AS has_dbrid_index,
        BOOL_OR(COALESCE(_columns.column_name, '') = 'insert_date')                                           AS has_insert_date,
        BOOL_OR(COALESCE(_columns.column_name, '') = 'insert_by')                                             AS has_insert_by,
        BOOL_OR(COALESCE(_columns.column_name, '') = 'modified_by')                                           AS has_modified_by,
        BOOL_OR(COALESCE(_columns.column_name, '') = 'modified_date')                                         AS has_modified_date,
        -- wiedervorlagen // alte daten die gelöscht werden müssen
        BOOL_OR(COALESCE(_columns.column_name, '') = 'wvod')                                                  AS has_wvod,
        -- dokumenten verwaltungszeug // alte daten die gelöscht werden müssen
        BOOL_OR(COALESCE(_columns.column_name, '') = 'doku')                                                  AS has_doku,
        BOOL_OR(COALESCE(_triggers.trigger_name, '') = _tables.table_name || '_delete_abkstru')               AS has_abk,
        NOT BOOL_OR(COALESCE(_triggers.trigger_name, '') = _tables.table_name || '_table_detele')             AS has_no_recno, -- BOOL_AND(... <> ...) geht auch
        BOOL_OR(COALESCE(_triggers.trigger_name, '') = _tables.table_name || '_set_modified')                 AS has_modified_trigger, -- TRIGGER table_modified
        BOOL_OR(COALESCE(_columns.column_name, '') = 'dbrid' AND COALESCE(character_maximum_length, 0) > 32)  AS dbrid_not_varchar32,
        lower(_tables.table_name) IN ('tablefieldinfo', 'do_artikel_bedarf', 'bedarf', 'lagerlog', 'auftgposlog', 'opreg', 'auditlog', 'stvtrs_res_log', 'bde__terminal__log', 'dblog', 'dblogfiles_imported')                                    AS does_not_need_dbrid,
        lower(_tables.table_name) IN ('tablefieldinfo', 'do_artikel_bedarf', 'bedarf', 'lagerlog', 'auftgposlog', 'opreg', 'auditlog', 'stvtrs_res_log', 'bde__terminal__log', 'dblog', 'dblogfiles_imported')                                    AS does_not_need_dates,
        lower(_tables.table_name) IN ('tablefieldinfo', 'do_artikel_bedarf', 'bedarf', 'lagerlog', 'auftgposlog', 'opreg', 'auditlog', 'stvtrs_res_log', 'bde__terminal__log', 'dblog', 'dblogfiles_imported', 'auftg_planauftg', 'recnokeyword') AS does_not_need_recno  -- TRIGGER table_detele
      FROM information_schema.tables AS _tables
        LEFT JOIN information_schema.columns  AS _columns
             ON _columns.table_schema = _tables.table_schema
            AND _columns.table_name = _tables.table_name
            AND _columns.column_name IN ('dbrid', 'insert_date', 'insert_by', 'modified_by', 'modified_date', 'wvod', 'doku')
        LEFT JOIN pg_indexes AS _indexes
             ON _indexes.schemaname = _tables.table_schema
            AND _indexes.tablename = _tables.table_name
            AND ( _indexes.indexname ~ '__dbrid' OR _indexes.indexdef LIKE '%(dbrid)' )
        LEFT JOIN information_schema.triggers AS _triggers
             ON _triggers.event_object_schema = _tables.table_schema
            AND _triggers.event_object_table = _tables.table_name
            AND _triggers.trigger_name  IN (_tables.table_name || '_delete_abkstru', _tables.table_name || '_table_detele', _tables.table_name || '_set_modified')
      WHERE _tables.table_type = 'BASE TABLE' -- => nur Tables.  -- Type of the table: BASE TABLE for a persistent base table (the normal table type), VIEW for a view, FOREIGN for a foreign table, or LOCAL TEMPORARY for a temporary table => https://www.postgresql.org/docs/current/infoschema-tables.html
        AND lower(_tables.table_schema) NOT IN ('pg_catalog', 'information_schema', 'tcache', 'tsystem', 'scheduling', 'sunext'/*!!*/, 'import'/*!!*/, 'z_99_drop', 'x_950_import', 'x_900_export', 'x_10_interfaces', 'management'/*!!*/, 'z_50_customer__eabk'/*!!*/ /*!customer %?! => hätten lokale tables nie dbrid*/) -- IMPORT IMNOO TLOG USW
      GROUP BY _tables.table_name, _tables.table_schema
      ORDER BY _tables.table_name, _tables.table_schema
  $$ LANGUAGE sql;
  --

/*CleanUp: => Template for DBUPDATE
ALTER TABLE stvtrs_res_log DROP COLUMN IF EXISTS dbrid CASCADE;
ALTER TABLE stvtrs_res_log DROP COLUMN IF EXISTS insert_by;
ALTER TABLE stvtrs_res_log DROP COLUMN IF EXISTS modified_by;
ALTER TABLE stvtrs_res_log DROP COLUMN IF EXISTS insert_date;
ALTER TABLE stvtrs_res_log DROP COLUMN IF EXISTS modified_date;

DROP TRIGGER IF EXISTS stvtrs_res_log_table_detele ON stvtrs_res_log; -- replace part "stvtrs" 2 MAL!!!!
DROP TRIGGER IF EXISTS stvtrs_res_log_set_modified ON stvtrs_res_log;
*/

--
CREATE OR REPLACE FUNCTION TSystem.tables__generate_missing_fields() RETURNS int AS $$
    DECLARE
      count               int DEFAULT 0;
      table_not_inherited bool;
      table_is_fdw        bool;
      errmessage          TEXT;
      err_context         TEXT;
      row                 RECORD;
    BEGIN
      errmessage:='';
      FOR row IN
          SELECT
            *
          FROM TSystem.tables__fieldInfo__fetch() -- WHERE schemaname NOT IN ('z_99_drop') -- Ausschlüsse sind bereits in tables__fieldInfo__fetch
      LOOP
          -- Table Structure
          --------------------------------
          -- check if table is a children, otherwise skip all column creations
          table_not_inherited := NOT EXISTS ( SELECT 1 FROM   pg_catalog.pg_inherits WHERE  inhrelid = concat(quote_ident(row.schemaname) , '.' , quote_ident(row.tablename))::regclass );
          table_is_fdw        := TSystem.tables__is_fdw(row.tablename, row.schemaname);
          IF ( table_not_inherited AND NOT( table_is_fdw ) ) THEN
              -- add db_id_seq
              IF NOT row.has_dbrid AND NOT row.does_not_need_dbrid THEN
                 BEGIN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ADD COLUMN dbrid VARCHAR(32) NOT NULL DEFAULT nextval(''db_id_seq'');', row.schemaname, row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error ADD COLUMN DBRID :' || row.schemaname||'.'|| quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
                 BEGIN
                 EXECUTE FORMAT('CREATE UNIQUE INDEX %I ON %I.%I (dbrid);', row.tablename || '__dbrid' ,row.schemaname, row.tablename ); --beachte beleg_k__constraints__all__create
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error CREATE UNIQUE INDEX DBRID :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
              END IF;
              -- add insert_date
              IF NOT row.has_insert_date AND NOT row.does_not_need_dates THEN
                 BEGIN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ADD COLUMN insert_date DATE;', row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error ADD COLUMN insert_date :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
              END IF;
              -- add insert_by
              IF NOT row.has_insert_by AND NOT row.does_not_need_dates THEN
                 BEGIN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ADD COLUMN insert_by VARCHAR(32);', row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error ADD COLUMN insert_by :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
              END IF;
              -- add modified_date
              IF NOT row.has_modified_date AND NOT row.does_not_need_dates THEN
                 BEGIN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ADD COLUMN modified_date TIMESTAMP(0);', row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error ADD COLUMN modified_date :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
              END IF;
              -- add modified_by
              IF NOT row.has_modified_by AND NOT row.does_not_need_dates THEN
                 BEGIN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ADD COLUMN modified_by VARCHAR(32);', row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error ADD COLUMN modified_by :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
              END IF;
          END IF;
          -- Table  Trigger
          --------------------------------
          -- todo detele in delete umbenennen
          -- update modified date on insert or update
          IF NOT row.has_modified_trigger AND NOT row.does_not_need_dates AND NOT( table_is_fdw ) THEN
                 BEGIN
                 EXECUTE FORMAT('CREATE TRIGGER %I BEFORE INSERT OR UPDATE ON %I.%I FOR EACH ROW EXECUTE PROCEDURE table_modified();', row.tablename || '_set_modified',row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error CREATE TRIGGER set_modified :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
          END IF;
          -- recno trigger ertellen wenn nicht existent
          -- LG: Ich vermute das erste NOT war Quatsch.  IF NOT row.has_no_recno AND NOT row.does_not_need_recno THEN
          IF row.has_no_recno AND NOT row.does_not_need_recno AND NOT( table_is_fdw ) THEN
                 BEGIN
                 EXECUTE FORMAT('CREATE TRIGGER %I AFTER DELETE ON %I.%I FOR EACH ROW EXECUTE PROCEDURE table_delete();', row.tablename || '_table_detele',row.schemaname,row.tablename);
                 EXCEPTION
                    when others then
                        GET STACKED DIAGNOSTICS err_context = PG_EXCEPTION_CONTEXT;
                        errmessage:='Error CREATE TRIGGER table_detele :' || row.schemaname||'.'||quote_ident(row.tablename) || SQLERRM || E'\n'||
                                    'State:' || SQLSTATE || E'\n' ||
                                    'Context:' || err_context || E'\n';
                 END;
          END IF;
      END LOOP;

      IF errmessage <> '' THEN
          RAISE EXCEPTION 'tables__generate_missing_fields EXCEPTION: %', E'\n'||errmessage;
      END IF;

      RETURN 1;
    END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.tables__enforce__fieldtypes() RETURNS int AS $$
    DECLARE
      count               int DEFAULT 0;
      table_not_inherited bool;
      table_is_fdw        bool;
      row                 RECORD;
    BEGIN
      FOR row IN SELECT * FROM TSystem.tables__fieldInfo__fetch() WHERE schemaname NOT IN ('z_99_drop', 'drop', 'DROP') -- alle jemals verwendeten drop-Schemata ausschließen zwecks Abwärtskompatibilität
      LOOP
          -- Table Structure
          --------------------------------
          -- check if table is a children, otherwise skip all column creations
          table_not_inherited := NOT EXISTS ( SELECT 1 FROM pg_catalog.pg_inherits WHERE  inhrelid = concat(row.schemaname , '.' ,row.tablename)::regclass );
          table_is_fdw        := TSystem.tables__is_fdw(row.tablename, row.schemaname);
          IF ( table_not_inherited and NOT( table_is_fdw ) ) THEN
              -- change type db_id_seq
              IF row.has_dbrid AND (SELECT length FROM tablefieldinfo WHERE schemaname = row.schemaname AND tablename = row.tablename AND field = 'dbrid') <> 32 THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ALTER COLUMN dbrid TYPE VARCHAR(32);', row.schemaname, row.tablename);
              END IF;
              -- add insert_by
              IF row.has_insert_by AND (SELECT length FROM tablefieldinfo WHERE schemaname = row.schemaname AND tablename = row.tablename AND field = 'insert_by') <> 32 THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ALTER COLUMN insert_by TYPE VARCHAR(32);', row.schemaname, row.tablename);
              END IF;
              -- add modified_date
              IF row.has_modified_date
                 AND (   ((SELECT datetime_precision FROM information_schema.columns WHERE table_schema = row.schemaname AND table_name = row.tablename AND column_name = 'modified_date') <> '0')
                      OR ((SELECT data_type FROM information_schema.columns WHERE table_schema = row.schemaname AND table_name = row.tablename AND column_name = 'modified_date') <> 'timestamp without time zone')
                     )
              THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ALTER COLUMN modified_date TYPE TIMESTAMP(0);', row.schemaname, row.tablename);
              END IF;
              -- add modified_by
              IF row.has_modified_by AND (SELECT length FROM tablefieldinfo WHERE schemaname = row.schemaname AND tablename = row.tablename AND field = 'modified_by') <> 32 THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I ALTER COLUMN modified_by TYPE VARCHAR(32);', row.schemaname, row.tablename);
              END IF;
          END IF;
      END LOOP;

      RETURN count;
    END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.tables__fields__generate__defaults_values(
      _tablename regtype,
      _predefined_record jsonb default '{}'::jsonb
  ) RETURNS jsonb AS $$
  DECLARE
      _fieldN VARCHAR;
      _val TEXT;
      _tablefieldinfo_record RECORD;
      _convert_twawi BOOLEAN = False;
      _convert_tsystem_wawi BOOLEAN = False;
  BEGIN

      -- Viewnamen mappen und konvertieren
      CASE
      WHEN lower(_tablename::VARCHAR) = lower('TWawi.Ldsdok_pos')
      THEN
          _tablename     := 'ldsdok';
          _convert_twawi := True;

      WHEN lower(_tablename::VARCHAR) = lower('TWawi.auftg_pos')
      THEN
          _tablename     := 'auftg';
          _convert_twawi := True;

      WHEN lower(_tablename::VARCHAR) = lower('TWawi.einkauf_anfpos')
      THEN
          _tablename     := 'anfart';
          _convert_twawi := True;
      ELSE
      END CASE;

      FOR _tablefieldinfo_record IN
        -- alle Spalten der Tabelle durchlaufen und Defaults holen
        SELECT
            lower( fa_wawipos_map ) AS fa_wawipos_map,
            lower( field ) AS field,
            def
        FROM tablefieldinfo
        LEFT JOIN fieldalias ON
                  upper( fa_fieldname ) = upper( field )
              AND (
                       fa_tablename IS NULL
                    OR fa_tablename = tablename
                  )
        WHERE
                tablename = _tablename::varchar
            AND def IS NOT NULL

      LOOP

          -- Feldnamen auf wawi-view-fieldnamen mappen
          IF _convert_twawi THEN
              -- p_preis vor ag_vkp
              _FieldN := COALESCE( _tablefieldinfo_record.fa_wawipos_map, _tablefieldinfo_record.field );
          ELSE
              _FieldN := _tablefieldinfo_record.field;
          END IF;

          -- Feld gibts in Record bereits (kommt also schon mit Zuweisung hier an)
          IF ( _predefined_record ? _FieldN ) THEN
              CONTINUE;
          END IF;

          -- Rückgaberecord: DefaultValue setzen
          EXECUTE( 'SELECT '|| _tablefieldinfo_record.def )
          INTO _val;

          _predefined_record :=
                 _predefined_record
              || jsonb_object ( array[ _FieldN ]::text[], array[ _val ]::text[] );

      END LOOP;

    RETURN _predefined_record;

   END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.tables__is_fdw(
  _tablename varchar,
  _schemaname varchar
) RETURNS bool AS $$
DECLARE
  _exists bool;
BEGIN
  SELECT
    true

  FROM
    pg_class
  INNER JOIN
    pg_foreign_table ON pg_class.oid = pg_foreign_table.ftrelid
  JOIN
    pg_namespace ON pg_class.relnamespace = pg_namespace.oid
  WHERE
    pg_class.relname = _tablename
    AND pg_namespace.nspname = _schemaname
  INTO
    _exists;

  RETURN COALESCE(_exists, false);
END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.tables__cleanup_unused_fields() RETURNS int AS $$
    DECLARE
      count               int DEFAULT 0;
      table_not_inherited bool;
      table_is_fdw        bool;
      row                 RECORD;
    BEGIN
      FOR row IN SELECT * FROM TSystem.tables__fieldInfo__fetch() WHERE schemaname NOT IN ('z_99_drop', 'drop', 'DROP') -- alle jemals verwendeten drop-Schemata ausschließen zwecks Abwärtskompatibilität
      LOOP
          -- check if table is a children, otherwise skip all column creations
          table_not_inherited := NOT EXISTS ( SELECT 1 FROM   pg_catalog.pg_inherits WHERE  inhrelid = concat(row.schemaname , '.' ,row.tablename)::regclass );
          table_is_fdw        := TSystem.tables__is_fdw(row.tablename, row.schemaname);
          IF ( table_not_inherited and NOT( table_is_fdw ) ) THEN
              -- clean old wvod
              IF row.has_wvod THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I DROP COLUMN IF EXISTS wvod CASCADE;', row.schemaname,row.tablename);
              END IF;

              -- clean old wvod
              IF row.has_doku THEN
                 EXECUTE FORMAT('ALTER TABLE %I.%I DROP COLUMN IF EXISTS doku CASCADE;', row.schemaname,row.tablename);
              END IF;
          END IF;

          -- alte _delete_abkstru löschen
          IF row.has_abk THEN
            EXECUTE FORMAT('DROP TRIGGER IF EXISTS %I_delete_abkstru ON %I.%I', row.tablename,row.schemaname,row.tablename);
          END IF;
      END LOOP;

      RETURN count;
    END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.triggers__all__disable() RETURNS VOID AS $$
  DECLARE r RECORD;
  BEGIN
    BEGIN
      PERFORM TSystem.Settings__Set('triggersdisabled', True);
    EXCEPTION WHEN OTHERS THEN
      PERFORM TSystem.Settings__Set('triggersdisabled', True);
    END;

    FOR r IN
      --SELECT DISTINCT schemaname, tablename
      --FROM tablefieldinfo
      --WHERE schemaname NOT IN ('z_99_drop', 'import')
      --  AND tablename NOT IN ('tablefieldinfo')  -- es gibt ein SELECT darauf, drum lässt sich kein ALTER TABLE machen
      --  AND NOT isView
      SELECT DISTINCT table_schema AS schemaname, table_name AS tablename
      FROM information_schema.tables
      WHERE table_catalog = current_database()
        AND table_type = 'BASE TABLE'
        AND table_schema NOT IN ('information_schema', 'pg_catalog', 'z_99_drop', 'import')
    LOOP
      EXECUTE 'ALTER TABLE ' || quote_ident(r.schemaname) || '.' || quote_ident(r.tablename) || ' DISABLE TRIGGER ALL';
    END LOOP;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TSystem.triggers__all__enable() RETURNS VOID AS $$
  DECLARE r RECORD;
  BEGIN
    FOR r IN  -- aus TFormDBUpdates.Up_EnableTrigger -> lokales CodeSelect
      SELECT DISTINCT table_schema AS schemaname, table_name AS tablename
      FROM information_schema.tables
      WHERE table_catalog = current_database()
        AND table_type = 'BASE TABLE'
        AND table_schema NOT IN ('information_schema', 'pg_catalog', 'z_99_drop', 'import')
    LOOP
      EXECUTE 'ALTER TABLE ' || quote_ident(r.schemaname) || '.' || quote_ident(r.tablename) || ' ENABLE TRIGGER ALL';
    END LOOP;

    BEGIN
      PERFORM TSystem.Settings__Set('triggersdisabled', False);
    EXCEPTION WHEN OTHERS THEN
      PERFORM TSystem.Settings__Set('triggersdisabled', False);
    END;
  END $$ LANGUAGE plpgsql;
--
